﻿/*
VERSION:	2.0
	2.0		Fixed mis-named function call:  setZoom()  =>  setZoomIndex()
	2.0		(maybe) Fixed the draw-freeze glitch, by checking scroll values for NaN & the floor()-ing them

USAGE:
	#include "functions/addScrollPaneZoom.as"
	var zoomLevels = [25, 50, 100, 200, 400];
	addScrollPaneZoom( my_pane, 0, zoomLevels, 2 );
	
PROPERTIES:
	targetPane.zoomEnabled				Toggles whether or not zooming occurs
	targetPane.zoomIndex					Sets the zoom level  (if it's 2 steps below the lowest scale, it'll be set to only 1 step below it)

EVENTS:
	scrollWheel										Triggers when the scroll wheel is moved
	onZoom												Triggers when the content is scaled via zoom... Returns the new scale
	
KNOWN ISSUES:
	If "scrollDrag" is on, scrolling while zoomed out will be jittery.  (minor issue)
	
DEPTHS USED by ScrollPanes:
	_this: -16383
	_child0: 1
	mask_mc: 10000
	border_mc: -16383
	vScroller: 1002
	hScroller: 1001
	mask_mc: 10000
	vSB: 1002
	hSB: 1001
	spContentHolder: 1
	boundingBox_mc: -16000
	depthChild0: -16383
*/
addScrollPaneZoom = function( targetPane, scrollHandlerDepth, zoomLevels, initialZoomIndex )
{
	// disable normal wheel-scroll behavior  &  add "scrollWheel" event
	var scrollHandler_mc = targetPane.createEmptyMovieClip("scrollHandler_mc", scrollHandlerDepth);
	scrollHandler_mc.onEnterFrame = function(){		scrollHandler_mc.lastPosition = targetPane.vPosition;		}// loop()
	scrollHandler_mc.onMouseWheel = function( delta ){
		targetPane.vPosition = targetPane.scrollHandler_mc.lastPosition;
		if( targetPane.mask_mc.hitTest(_root._xmouse, _root._ymouse) )
			targetPane.dispatchEvent({type:"scrollWheel", delta:delta});
		targetPane.scrollHandler_mc.lastPosition = targetPane.vPosition;
	}// onMouseWheel()
	Mouse.addListener( scrollHandler_mc );
	scrollHandler_mc.onUnload = function(){
		Mouse.removeListener( targetPane.scrollHandler_mc );
	}// onUnload()
	
	
	
	// ----------------------------------------------------------------------------------
	
	
	
	var zoom_obj = targetPane.zoom_obj = {};
	
	// PROPERTIES
	targetPane.getZoomIndex = function(){
		return zoom_obj.zoomIndex;
	};targetPane.setZoomIndex = function(newValue, doEvent){
		zoom_obj.zoomIndex = newValue;
		zoom_obj.applyZoom( doEvent );
	}// get / set "zoomIndex"
	targetPane.addProperty( "zoomIndex", targetPane.getZoomIndex, targetPane.setZoomIndex );
	
	// zoom settings
	targetPane.zoomEnabled = true;
	zoom_obj.zoomLevels = zoomLevels;
	zoom_obj.setZoomIndex( initialZoomIndex, false );
	
	// Zoom Effect
	zoom_obj.applyZoom = function( doEvent )
	{
		if( targetPane.mask_mc.hitTest(_root._xmouse, _root._ymouse) )
		{// if:  mouse is hovering over content bounds
			// // where was the mouse on the old image
			var oldZoomPointX = targetPane.content._xmouse;
			var oldZoomPointY = targetPane.content._ymouse;
		}// if:  mouse is hovering over content bounds
		else
		{// if:  the mouse is not over the pane
			var oldZoomPointX = 0;
			var oldZoomPointY = 0;
		}// if:  the mouse is not over the pane
		// apply zoom
		var scale = zoom_obj.zoomLevels[zoom_obj.zoomIndex];
		// // prevent the content from zooming smaller than the viewable area
		var oldScale = targetPane.content._xscale;
		var oldWidth = targetPane.content._width;
		var oldHeight = targetPane.content._height;
		var newWidth = oldWidth * scale / oldScale;
		var newHeight = oldHeight * scale / oldScale;
		var newScaleW = scale;
		var newScaleH = scale;
		if( newWidth < targetPane.viewableColumns ){
			newScaleW = oldScale * targetPane.viewableColumns / oldWidth;
		}
		if( newHeight < targetPane.viewableRows ){
			newScaleH = oldScale * targetPane.viewableRows / oldHeight;
		}
		scale = Math.max(newScaleW, newScaleH);		// pick the larger one
		// select the closest or lower zoom level
		for(var z in zoom_obj.zoomLevels){
			if( zoom_obj.zoomLevels[z] <= scale ){
				zoom_obj.zoomIndex = z;
				break;
			}// if:  this zoomLevel matches or is one step below the current scale
		}// for each zoomLevel
		// apply new scale
		targetPane.content._xscale = targetPane.content._yscale = scale;
		// IMMEDIATELY update the scroll bar size  (to allow newly zoomed scroll range)  (invalidate() would do it later)
		targetPane.size();
		// adjust scroll position
		// // where would the old mouse's position be on the newly zoomed image
		var newZoomPointX = oldZoomPointX *(scale/100);
		var newZoomPointY = oldZoomPointY *(scale/100);
		// // offset that point to where the mouse is now
		newZoomPointX -= targetPane._xmouse;
		newZoomPointY -= targetPane._ymouse;
		// // scroll to that point
		if( !isNaN(newZoomPointX)  &&  !isNaN(newZoomPointX) ){
			targetPane.hPosition = Math.floor(newZoomPointX);
			targetPane.vPosition = Math.floor(newZoomPointY);
		}// if:  scroll points are valid
		
		// announce zoom
		if(doEvent != false){
			targetPane.dispatchEvent({type:"onZoom", zoomIndex:zoom_obj.zoomIndex});
			targetPane.onZoom(newValue);
		}
	}// applyZoom()
	
	
	
	zoom_obj.scrollWheel = function( evt )
	{
		if(targetPane.zoomEnabled)
		{// if:  zoom is enabled
			if( targetPane.mask_mc.hitTest(_root._xmouse, _root._ymouse) )
			{// if:  mouse is hovering over content bounds
				if( evt.delta>0 )
				{// if:  wheel up
					if(zoom_obj.zoomIndex<zoom_obj.zoomLevels.length-1)
						zoom_obj.zoomIndex++;
				}// if:  wheel up
				else
				{// if:  wheel down
					if(zoom_obj.zoomIndex>0)
						zoom_obj.zoomIndex--;
				}// if:  wheel down
				zoom_obj.applyZoom( true );
			}// if:  mouse is hovering over content bounds
		}// if:  zoom is enabled
	}// scrollWheel()
	
	
	
	// clean-up
	zoom_obj.unload = function()
	{
		targetPane.removeEventListener("scrollWheel", zoom_obj);
		targetPane.removeEventListener("unload", zoom_obj);
	}
	targetPane.addEventListener("scrollWheel", zoom_obj);
	targetPane.addEventListener("unload", zoom_obj);
}// addScrollPaneZoom()